/**
* \file: automounter_types.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#include "automounter_types.h"

//------------------------------ private attributes -----------------------------------------------------------------
static const char *partition_state_names[]=
{
		"PARTITION_DETECTED",
		"PARTITION_MOUNTING",
		"PARTITION_MOUNTED",
		"PARTITION_UNMOUNTING",
		"PARTITION_UNMOUNTED",
		"PARTITION_REMOUNTING",
		"PARTITION_INVALID",
		"PARTITION_UNSUPPORTED",
		"PARTITION_MOUNT_ERR",
		"_UNKNOWN_PARTITION_STATE"
};

static const char *partition_unsupported_reason_text[]=
{
	"_SUPPORTED",
	"UNSUPPORTED_FILESYSTEM",
	"NO_FILESYSTEM",
	"AUDIO_CD",
	"AUDIO_MIXED_MODE",
	"BLACKLISTED"
};

static const char *device_state_names[]=
{
		"DEVICE_DETECTED",
		"DEVICE_AUTOMOUNTING",
		"DEVICE_AUTOMOUNTED",
		"DEVICE_UNMOUNTING",
		"DEVICE_UNMOUNTED",
		"DEVICE_INVALID",
		"DEVICE_NOMEDIA",
		"_UNKNOWN_DEVICE_STATE"
};
//-------------------------------------------------------------------------------------------------------------------

//------------------------------ public functions -------------------------------------------------------------------
const char *automounter_get_device_state_string(device_state_t state)
{
	return device_state_names[state];
}

const char *automounter_get_partition_state_string(partition_state_t state)
{
	return partition_state_names[state];
}

const char *automounter_get_unsupported_reason_string(partition_unsupported_reason_t reason)
{
	return partition_unsupported_reason_text[reason];
}
//-------------------------------------------------------------------------------------------------------------------
